<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    $result = $geecomDb->eseguiQueryLettura("SHOW TABLES LIKE 'geec_prodotti'");
    if($result->num_rows>0) {
        session_start();
        $_SESSION["altriProdotti"]="si";
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <title>Installazione di Geecom CMS</title>
        <?php
            include "../amministrazione/include/cssBaseAreaAmministrativa.php";
        ?>
	  
    </head>
    <body class="bg-primary">
        <main role="main" class="d-flex align-items-center mt-0">
            <div id="installazione" class="container">
                <div class="row">
                    <div class="col-sm-8 col-md-6 mx-auto">
                        <div class="card box-shadow-lite mb-4">
                            <div class="row">
                                <div class="col-8 col-lg-6 mx-auto">
                                    <img class="img-fluid logo mb-4" src="../template/img/geecom.svg" />
                                </div>
                                <div class="col-12">
                                    <?php
                                        if(isset($_SESSION["altriProdotti"])) {
                                            echo"<p class=\"alert alert-success\"> Rilevati altri prodotti Geecom, dopo l'installazione sarà possibile passare da un prodotto all'altro tramite l'area riservata. </p>";
                                        }
                                    ?>
                                    <p>Benvenuto! Geecom è quasi pronto.<br>
                                    Compila i campi seguenti per completare l'installazione:</p>                                        
                                </div>
                            </div>

                            <form name="formInstallazione" action="install.php" method="post">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="exampleInputEmail1">Nome Utente</label>
                                        <input type="text" class="form-control" name="nome" id="exampleInputText1" placeholder="Nome utente">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="exampleInputEmail1">Cognome Utente</label>
                                        <input type="text" class="form-control" name="cognome" id="exampleInputText1" placeholder="Cognome utente">
                                    </div>

                                    <div class="form-group col-12">
                                        <label for="exampleInputEmail1">Email</label>
                                        <input type="email" class="form-control" name="email" id="exampleInputEmail1" placeholder="Email">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control " name="password" id="password" placeholder="Password">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="password2">Conferma password</label>
                                        <input type="password" class="form-control " id="password2" placeholder="Conferma password">
                                    </div>

                                    <div class="form-group col-12">
                                        <label for="nomeSito">Titolo sito </label><i class="fas fa-info-circle ml-2" data-toggle="tooltip" data-placement="right" title="Inserisci il nome del tuo sito, comparirà nel tag title di tutte le pagine"></i>
                                        <input type="text" class="form-control" id="titoloSito" name="titoloSito" placeholder="Titolo sito">
                                    </div>

                                    <div class="form-group col-12">
                                        <label for="urlSito">URL sito</label><i class="fas fa-info-circle ml-2" data-toggle="tooltip" data-placement="right" title="Inserisci l'url del sito, generalmente viene compilato in automatico"></i>
                                        <input type="text" class="form-control" id="urlSito" name="urlSito" value="http://<?php echo $_SERVER['HTTP_HOST'].str_replace("/installazione/","",$_SERVER['REQUEST_URI']); ?>" placeholder="Esempio: http://www.miosito.it">
                                    </div>

                                    <?php 
                                        $alfabeto      = "abcdefghijklmnopqrstuvwxyz";
                                        $stringaCasuale = rand(10,999).$alfabeto[rand(0,25)].rand(10,999).$alfabeto[rand(0,25)].rand(10,999);
                                    ?>
                                    <div class="form-group col-12">
                                        <label for="cartellaAmministrazione">Nome cartella amministrativa</label><i class="fas fa-info-circle ml-2" data-toggle="tooltip" data-placement="right" title="Per motivi di sicurezza il nome della cartella amministrativa deve essere sempre diverso. Scegli il nome che preferisci"></i>
                                        <input type="text" class="form-control" id="cartellaAmministrazione" name="cartellaAmministrazione" placeholder="esempio: amministrazione123" value="<?php echo "amministrazione$stringaCasuale"; ?>">
                                    </div>
                                    
                                    <div class="form-group col-12">
                                        <div class="alert alert-info p-3 mb-0">
                                            <b>Geecom è un software open source rilasciato sotto licenza GPL V3.</b> Il prodotto è distribuito
                                            <b>senza alcuna garanzia</b>, gli sviluppatori non sono responsabili dell'uso che ne viene fatto.
                                            Per maggiori informazioni leggi il <a href="https://www.gnu.org/licenses/gpl-3.0.html" target="_blank"><b>testo completo della licenza</b></a>
                                            
                                            <br><br>
                                            <strong>Attenzione!</strong> Un ecommerce non è un semplice sito internet, è un'attività imprenditoriale soggetta alle 
                                                leggi dello stato in cui viene registrato. Geecom e il suo componente e-commerce sono strumenti che 
                                                consentono di vendere online, richiedono conoscenza del prodotto e delle normative.

                                            <div class="custom-control custom-checkbox mt-3">
                                                <input type="checkbox" class="custom-control-input" id="accettazioneTerminiCondizioni">
                                                <label class="custom-control-label" for="accettazioneTerminiCondizioni">Accetto la licenza di Geecom e le condizioni di utilizzo del componente e-commerce</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <button type="button" onclick="controlloForm()" class="btn btn-primary btn-block">Installa</button>
                            </form>
                        </div><!-- /card-container -->
                    </div>
                </div>
            </div><!-- /container -->
        </main>

        <footer class="footer">
          <div class="container text-center"><?php echo $infoGeecom["versione"]; ?></div>
        </footer>
	  
	<?php 
            include "../amministrazione/include/jsBaseAreaAmministrativa.php";
        ?>
        
        <!-- Password strength meter -->
	<script type="text/javascript" src="../plugins/password-strength-meter-1.1.0/dist/password.min.js"></script>
	<script type="text/javascript">
            jQuery(document).ready(function($) {
                $('#password').password({
                  shortPass: '<span class="pwd-corta">La password è troppo corta, usa una password <strong>FORTE</strong> per scongiurare attacchi al tuo sito</span>',
                  badPass: '<span class="pwd-insufficiente">Insufficiente. Prova a combinare lettere e numeri</span>',
                  goodPass: '<span class="pwd-media">Media, aggiungi un carattere speciale per renderla più sicura</span>',
                  strongPass: '<span class="pwd-forte">Password forte</span>',
                  containsUsername: '<span class="pwd-corta">La tua password contiene lo username! Per motivi di sicurezza è bene sia diversa</span>',
                  enterPass: '',
                  showPercent: false,
                  animate: false,
                  minimumLength: 6,
                });
            });
        </script>
    
        <script>
            
            function controlloForm() {
                var checkbox = document.getElementById("accettazioneTerminiCondizioni");
                var pass = document.getElementById("password").value;
                var pass2 = document.getElementById("password2").value;
                var cartellaAmministrazione = document.getElementById("cartellaAmministrazione").value;
                
                if(pass==pass2 && pass!="" && checkbox.checked) {
                    document.formInstallazione.submit();
                }
                else if(!checkbox.checked) {
                    alert("Devi accettare le condizioni d'uso");
                }
                else if(pass=="") {
                    alert("Inserisci la password");
                }
                else if(cartellaAmministrazione=="") {
                    alert("La cartella dell'area amministrativa non può essere vuota ");
                }
                else if(cartellaAmministrazione.indexOf(" ")>-1) {
                    alert("Il nome della cartella amministrativa non può contenere spazi");
                }
                else {
                    alert("Le password devono coincidere");
                }
            }
        </script>
    </body>
</html>
